 package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityPassForgetBinding;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.ForgetPasswordRequest;
import app.firezone.synk.network.model.ForgetPasswordResponse;
import app.firezone.synk.network.model.OtpVerifyRequest;
import app.firezone.synk.network.model.OtpVerifyResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

 public class PassForgetActivity extends AppCompatActivity {

    ActivityPassForgetBinding binding;

    private  MyApi myApi;

    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding =  ActivityPassForgetBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        dialog = new Dialog(this);
        dialog.setContentView(R.layout.loading_dialog);


        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(false);
        }




        binding.btnResetPass.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (binding.cardView4.getVisibility() == View.VISIBLE){
                    String otp =  binding.otpEditBox.getText().toString().trim();
                    String email=  binding.resetEmail.getText().toString().trim();
                    if (!TextUtils.isEmpty(otp)){
                        verifyOtp(email, otp);
                        dialog.show();
                    }else {
                        binding.otpEditBox.setError("Enter Otp");
                    }
                }else {
                    String email=  binding.resetEmail.getText().toString().trim();

                    if (!TextUtils.isEmpty(email)){
                        checkEmailExistandLoginVia(email);
                        dialog.show();
                    }else {
                        binding.resetEmail.setError("Enter Valid Email");
                    }
                }


            }
        });


        binding.rememberPass.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(PassForgetActivity.this, LoginActivity.class));
            }
        });

    }

     private void checkEmailExistandLoginVia(String email) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
         Call<CheckEmailResponse> call = myApi.checkEmailExists(email);

         call.enqueue(new Callback<CheckEmailResponse>() {
             @Override
             public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                 if (response.isSuccessful() && response.body() != null) {
                     if (response.body().isSuccess()) {
                         int loginVia = response.body().getLoginVia();

                         if (loginVia == 0) {
                             forgetPassword(email);
                         } else if (loginVia == 1) {
                             dialog.dismiss();
                             Toast.makeText(PassForgetActivity.this, "This account was created using Google Sign-In.", Toast.LENGTH_SHORT).show();
                         }
                     } else {
                         Toast.makeText(PassForgetActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                     }
                 }
             }

             @Override
             public void onFailure(Call<CheckEmailResponse> call, Throwable throwable) {
                 Toast.makeText(PassForgetActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
             }
         });
     }

     private void forgetPassword(String email) {
         myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
         ForgetPasswordRequest request = new ForgetPasswordRequest(email);

         myApi.forgetPassword(request).enqueue(new Callback<ForgetPasswordResponse>() {
             @Override
             public void onResponse(Call<ForgetPasswordResponse> call, Response<ForgetPasswordResponse> response) {
                 dialog.dismiss();

                 if (response.isSuccessful() && response.body() != null) {
                     ForgetPasswordResponse res = response.body();
                     if (res.isSuccess()) {
                         binding.cardView4.setVisibility(View.VISIBLE);
                         binding.btnResetPass.setText("Verify OTP");
                         Toast.makeText(PassForgetActivity.this, "OTP sent to your email. \n( Please also Spam folder )", Toast.LENGTH_SHORT).show();
                     } else {
                         Toast.makeText(PassForgetActivity.this, res.getMessage(), Toast.LENGTH_SHORT).show();
                     }

                 } else {
                     try {
                         String errorBody = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                         Log.e("API_ERROR", errorBody);
                         Toast.makeText(PassForgetActivity.this, "Error: " + errorBody, Toast.LENGTH_SHORT).show();
                     } catch (Exception e) {
                         Toast.makeText(PassForgetActivity.this, "Failed to read error response", Toast.LENGTH_SHORT).show();
                         Log.e("API_ERROR", "Exception: " + e.getMessage());
                     }
                 }
             }

             @Override
             public void onFailure(Call<ForgetPasswordResponse> call, Throwable t) {
                 dialog.dismiss();
                 Toast.makeText(PassForgetActivity.this, "Failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                 Log.e("API_FAILURE", t.getMessage(), t);
             }
         });
     }


     private void verifyOtp(String email, String otp) {
         MyApi myApi = APIClient.getApiClient(this).create(MyApi.class);

         OtpVerifyRequest request = new OtpVerifyRequest(email, otp);

         myApi.verifyOtp(request).enqueue(new Callback<OtpVerifyResponse>() {
             @Override
             public void onResponse(Call<OtpVerifyResponse> call, Response<OtpVerifyResponse> response) {
                 dialog.dismiss();
                 if (response.isSuccessful() && response.body() != null) {
                     OtpVerifyResponse res = response.body();

                     if (res.isSuccess()) {
                         long userId = res.getUserId();
                         Toast.makeText(PassForgetActivity.this, "OTP Verified Successfully", Toast.LENGTH_SHORT).show();
                         // Proceed to password reset screen or login
                         Intent intent = new Intent(PassForgetActivity.this, ForgetPassChangeActivity.class);
                         intent.putExtra("userId", userId);
                         startActivity(intent);
                         finish();

                     } else {
                         dialog.dismiss();
                         Toast.makeText(PassForgetActivity.this, res.getMessage(), Toast.LENGTH_SHORT).show();
                     }
                 } else {
                     dialog.dismiss();
                     Toast.makeText(PassForgetActivity.this, "Verification failed. Try again.", Toast.LENGTH_SHORT).show();
                 }
             }

             @Override
             public void onFailure(Call<OtpVerifyResponse> call, Throwable t) {
                 dialog.dismiss();
                 Toast.makeText(PassForgetActivity.this, "Network error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
             }
         });
     }


 }